import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, logical_and, logical_or, assert_series


atp_tennis = read_csv_file('atp_tennis.csv')

def calculate_performance(player, opponent, data, surface_types):
    player_matches = data[logical_or(logical_and(assert_series(data['Player_1'], player, 'equality'), assert_series(data['Player_2'], opponent, 'equality')), logical_and(assert_series(data['Player_1'], opponent, 'equality'), assert_series(data['Player_2'], player, 'equality')))]
    total_matches = len(player_matches)
    wins = len(player_matches[assert_series(player_matches['Winner'], player, 'equality')])
    win_rate = wins / total_matches if total_matches > 0 else 0

    h2h_record = wins / total_matches if total_matches > 0 else 0

    surface_performance = {}
    for surface in surface_types:
        player_surface_matches = player_matches[assert_series(player_matches['Surface'], surface, 'equality')]
        player_surface_wins = len(player_surface_matches[assert_series(player_surface_matches['Winner'], player, 'equality')])
        surface_performance[surface] = player_surface_wins / player_surface_matches.shape[0] if player_surface_matches.shape[0] > 0 else 0

    return win_rate, h2h_record, surface_performance
